DISK   ;DISK/ASM
 READ	LD	HL,READ1	;where to go
 	JR	READWRT		;go common routine
 WRITE	LD	HL,WRITE1
 READWRT	LD	(RWRTCALL),HL	;put into code
 	LD	(RWRTCALL2),HL	;here too
 	PUSH	BC		;save load address
 	CALL	SELDEN		;select density chip
 	CALL	0		;call read/write
 RWRTCALL	EQU	$-2
 	POP	HL		;get load address
 	RET	Z		;return if OK
 	LD	B,H		;restore load address
 	LD	C,L
 	PUSH	BC
 	CALL	0
 RWRTCALL2	EQU	$-2
 	POP	HL
 	RET	Z
 	LD	B,H
 	LD	C,L
 	RET
 READ1	CALL	SEEK		;move the head to track
 	RET	NZ		;bad
 READ1S	CALL	SELECT
 	RET	NZ
 	LD	HL,37ECH
 	DI
 	LD	(HL),88H	;give read command to FDC
 RDTYPE	EQU	$-1
 	PUSH	DE		;save track/sector
 	LD	DE,37EFH	;data transfer address
 	CALL	RXFER		;transfer the data
 	POP	DE		;restore track/sector
 	PUSH	AF		;save result
 	RRCA
 	RRCA
 	RRCA
 	RRCA
 	RRCA
 	AND	3
 	OR	0A0H		;make it a write command
 	LD	L,A		;save it here
 	LD	A,(RDTYPE)	;get type of read
 	AND	8		;IBM or not?
 	OR	L		;now have a write command
 	LD	(WRTYPE),A	;that will produce the
 	EX	AF,AF'		;same as this read.
 	POP	AF		;put write byte in af'
 	AND	9CH		;check for error
 IOCOMM	PUSH	AF		;save it
 	LD	A,(37EDH)	;get FDC track
 	SCF			;carry = put in table
 	CALL	GETTRK		;save current track
 	POP	AF		;restore result
 	RET			;done
 WRITE1	CALL	SEEK		;move head
 	RET	NZ		;error occured
 WRITE1S	CALL	SELECT
 	RET	NZ
 	LD	HL,37ECH
 	DI
 	LD	(HL),0A8H
 WRTYPE	EQU	$-1
 	PUSH	DE
 	LD	DE,37EFH
 	CALL	WXFER		;write data to the disk
 	POP	DE
 	AND	0FCH		;error test
 	JR	IOCOMM		;put track in table
 SEEK	CALL	SELECT		;turn on drive
 	LD	HL,37ECH	;point to FDC
 	RET	NZ		;not ready
 	OR	A		;clear carry
 	CALL	GETTRK		;get track from table
 	JR	NZ,SEKCNT	;continue if not
 	CALL	RESTORE		;restore disk drive
 	RET	NZ		;not in system
 	XOR	A		;set track 0
 SEKCNT	LD	(37EEH),DE	;select track/sector
 	LD	(37EDH),A	;give to track register
 	CP	D		;same as request?
 	RET	Z		;return if yes
 	JP	DOSEEK		;seek the track
 SELECT	LD	A,(37ECH)	;read drive status
 	BIT	7,A		;motor on?
 	LD	A,0		;get drive bit pattern
 DRIVE	EQU	$-1
 	LD	(37E1H),A	;give to FDC
 	RET	Z		;return if motor on
 	PUSH	BC		;don't touch this
 	LD	BC,0
 	CALL	60H		;countdown till BC=0
 	POP	BC
 	LD	A,(37ECH)	;read status again
 	BIT	7,A		;bit 7 = ready if 0
 	RET			;return ready condition
 DSKSLO	EX	(SP),HL
 	EX	(SP),HL		;FDC to deliver a
 	EX	(SP),HL		;valid status byte
 	EX	(SP),HL
 	RET
 GETTRK	PUSH	HL		;save all registers
 	LD	HL,TRACK
 	JR	GETCOMM
 GETTYPE	PUSH	HL
 	LD	HL,TYPES
 GETCOMM	PUSH	AF		;save carry flag
 	LD	A,0		;get binary drive
 DRIV	EQU	$-1
 	ADD	A,L		;point to right byte
 	LD	L,A
 	POP	AF		;restore it
 	JR	C,PUTIN		;C = put in table
 	LD	A,(HL)		;get it out
 PUTIN	LD	(HL),A		;put it right back
 	POP	HL		;stack is restored
 	OR	A		;set new flags
 	RET
 RESTORE	LD	A,8		;fast restore command
 MOVCOMM	LD	(SAVMOV),A	;save for later mask
 	LD	HL,37ECH	;point to FDC
 	CALL	SELECT		;turn on drive
 	RET	NZ		;back in error
 	OR	A		;clear carry
 	CALL	GETTYPE		;get drive type
 	AND	3		;set step speed
 	OR	0		;or with command mask
 SAVMOV	EQU	$-1
 	CALL	MOVEHEAD	;move the head to track
 	RET	NZ		;seek error
 	LD	A,(37EDH)	;get current track
 	SCF			;for put in table
 	CALL	GETTRK		;put it in
 	XOR	A		;set Z flag
 	RET
 MOVEHEAD	LD	(HL),A	;command to FDC
 MOVWT	CALL	SELECT		;prevent time-out
 	RET	NZ		;quit if drops ready
 	BIT	0,(HL)		;command done ?
 	JR	NZ,MOVWT	;wait some more
 	RET			;done
 STEPIN	LD	A,58H		;fast step-in command
 	JR	MOVCOMM
 STEPOUT	LD	A,78H		;fast step-out command
 	JR	MOVCOMM
 DOSEEK	LD	A,18H		;fast seek command
 	JR	MOVCOMM
 SETDRV	LD	(DRIV),A	;a = binary drive #
 	PUSH	BC		;save this
 	LD	C,1		;start with bit 0
 SETDLP	OR	A		;binary 0?
 	JR	Z,SETDDN	;have bit if yes
 	SLA	C		;move drive bit left
 	DEC	A		;binary -1
 	JR	SETDLP+1	;zero now?
 SETDDN	LD	A,C		;get bit pattern
 	LD	(DRIVE),A	;save for select
 	POP	BC		;restore it
 DRVASC	LD	A,(DRIV)	;get binary drive
 	ADD	A,30H		;make it ascii
 	RET			;that's all
 	DEC	A		;binary -1
 	JR	SETDLP+1	;zero now?
 SETDDN	LD	A,C		;get bit p